//AIM:Computation of N-Point DFT using DIF method.
//Software version Scilab 5.5.2
//OS windows 10
clc;
clear;
// We will compute the DFT of the sequence x(n)={1,2,3,4,5,6}
//using DIF(Split radix) method for N=6(3*2)
//Let us begin with the programming.For understanding,let us write the given data as
//x(0)=1;x(1)=2,x(2)=3,x(3)=4,x(4)=5,x(5)=6
x0=1;//DIF-FFT,so arranging the input in natural order
x1=2;//DIF-FFT,so arranging the input in natural order
x2=3;//DIF-FFT,so arranging the input in natural order
x3=4;//DIF-FFT,so arranging the input in natural order
x4=5;//DIF-FFT,so arranging the input in natural order
x5=6;//DIF-FFT,so arranging the input in natural order

//Computing the twiddle factors
W0=cos((2*%pi/6)*0)-(sqrt(-1))*sin((2*%pi/6)*0)
disp(W0,'W0=')
W1=cos((2*%pi/6)*1)-(sqrt(-1))*sin((2*%pi/6)*1)
disp(W1,'W1=')
W2=cos((2*%pi/6)*2)-(sqrt(-1))*sin((2*%pi/6)*2)
disp(W2,'W2=')
W3=cos((2*%pi/6)*3)-(sqrt(-1))*sin((2*%pi/6)*3)
disp(W3,'W3=')
W4=cos((2*%pi/6)*4)-(sqrt(-1))*sin((2*%pi/6)*4)
disp(W4,'W4=')
W5=cos((2*%pi/6)*5)-(sqrt(-1))*sin((2*%pi/6)*5)
disp(W5,'W5=')

//Stage I computations
x0a=x0+x3;
x1b=x1+x4;
x2c=x2+x5;
x3d=x0-x3;
x4e=x1-x4;
x5f=x2-x5;

//Stage II computations
X0=x0a+x1b+x2c;
X2=x0a+x1b*W2+x2c*W4;//at line 2, x1b and x2c are to be multiplied by twiddle factor W2 and W4 respectively
X4=x0a+x1b*W4+x2c*W2;//at line 3, x1b and x2c are to be multiplied by twiddle factor W4 and W2 respectively
X1=x3d+x4e*W1+x5f*W2;//at line 4, x4e and x5f are to be multiplied by twiddle factor W1 and W2 respectively
X3=x3d+x4e*W1*W2+x5f*W2*W4;//at line 5, x4e and x5f are to be multiplied by twiddle factor W1,W2 and W2,W4 respectively
X5=x3d+x4e*W1*W4+x5f*W2*W2;//at line 6, x4e and x5f are to be multiplied by twiddle factor W1,W4 and W2,W2 respectively

disp(X0,'X(0)=')
disp(X2,'X(2)=')
disp(X4,'X(4)=')
disp(X1,'X(1)=')
c=- 3. - 1.332D-15
X3=ceil(c)
disp(X3,'X(3)=')
disp(X5,'X(5)=')
disp({X0,X1,X2,X3,X4,X5},'So,the DFT of x(n) using Decimation-in-Frequency Fast Fourier Transform(DIF-FFT) is X(k)=')

//Expected output:X(k)={21,-3+5.1961524i,-3+1.7320508i,-3,-3-1.7320508i,-3-5.1961524i}
